<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;

/**
 * GpwIndex
 *
 * @ORM\Table(name="gpw_indexes")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\GpwIndexRepository")
 * @ORM\HasLifecycleCallbacks()
 *
 * @ExclusionPolicy("all")
 */
class GpwIndex
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="symbol", type="string", length=30, unique=true)
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $symbol;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=true)
     */
    private $name;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="createAt", type="datetime")
     */
    private $createAt;

    /**
     * @var integer
     *
     * @ORM\Column(name="type_id", type="integer")
     */
    private $typeId;

    /**
     * @ORM\ManyToOne(targetEntity="GpwType",inversedBy="indexes")
     * @ORM\JoinColumn(name="type_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"quotesList"})
     */
    private $type;

    /**
     * @ORM\OneToMany(targetEntity="GpwSession", mappedBy="index")
     * @ORM\OrderBy({"date" = "DESC"})
     *
     */
    private $sessions;

    /**
     * @ORM\PrePersist
     */
    public function prePersist()
    {
        $this->createAt = new \DateTime();
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->sessions = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set symbol
     *
     * @param string $symbol
     * @return GpwIndex
     */
    public function setSymbol($symbol)
    {
        $this->symbol = $symbol;
    
        return $this;
    }

    /**
     * Get symbol
     *
     * @return string 
     */
    public function getSymbol()
    {
        return $this->symbol;
    }

    /**
     * Set name
     *
     * @param string $name
     * @return GpwIndex
     */
    public function setName($name)
    {
        $this->name = $name;
    
        return $this;
    }

    /**
     * Get name
     *
     * @return string 
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set createAt
     *
     * @param \DateTime $createAt
     * @return GpwIndex
     */
    public function setCreateAt($createAt)
    {
        $this->createAt = $createAt;
    
        return $this;
    }

    /**
     * Get createAt
     *
     * @return \DateTime 
     */
    public function getCreateAt()
    {
        return $this->createAt;
    }

    /**
     * Set typeId
     *
     * @param integer $typeId
     * @return GpwIndex
     */
    public function setTypeId($typeId)
    {
        $this->typeId = $typeId;
    
        return $this;
    }

    /**
     * Get typeId
     *
     * @return integer 
     */
    public function getTypeId()
    {
        return $this->typeId;
    }

    /**
     * Set type
     *
     * @param \Import\ApiBundle\Entity\GpwType $type
     * @return GpwIndex
     */
    public function setType(\Import\ApiBundle\Entity\GpwType $type = null)
    {
        $this->type = $type;
    
        return $this;
    }

    /**
     * Get type
     *
     * @return \Import\ApiBundle\Entity\GpwType 
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Add sessions
     *
     * @param \Import\ApiBundle\Entity\GpwSession $sessions
     * @return GpwIndex
     */
    public function addSession(\Import\ApiBundle\Entity\GpwSession $sessions)
    {
        $this->sessions[] = $sessions;
    
        return $this;
    }

    /**
     * Remove sessions
     *
     * @param \Import\ApiBundle\Entity\GpwSession $sessions
     */
    public function removeSession(\Import\ApiBundle\Entity\GpwSession $sessions)
    {
        $this->sessions->removeElement($sessions);
    }

    /**
     * Get sessions
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getSessions()
    {
        return $this->sessions;
    }
}